// Get the current URL path
const currentPath = window.location.pathname;

// Split the path into segments
const pathSegments = currentPath.split('/');

// Get the userId from the URL path
const userId = pathSegments[1]; // Assumes userId is the first non-empty segment

// Construct the PHP endpoint URL with the userId included in the path
const configPath = `/${userId}/includes/config.php`; // URL pattern: /USER_ID/includes/config.php

// Fetch the Firebase configuration from the PHP endpoint
fetch(configPath)
  .then(response => {
    if (!response.ok) {
      throw new Error('Failed to fetch Firebase config');
    }
    return response.json(); // Parse the response as JSON
  })
  .then(firebaseConfig => {
    // Initialize Firebase with the fetched config
    firebase.initializeApp(firebaseConfig);

    console.log('Firebase initialized successfully');

    // Additional code using `userId`...
  })
  .catch(error => {
    console.error('Error fetching Firebase config:', error);
  });
