<?php
// Check if the folder name is provided in the URL
if (isset($_GET['createfolder'])) {
    $folder_name = $_GET['createfolder'];
    
    // Directory where you want to create the folder
    $output_dir = "/home3/smartag1/profitable.lk/"; // Change this to the desired directory path
    $target_folder_path = $output_dir . $folder_name;

    // Check if the folder already exists and delete it if it does
    if (file_exists($target_folder_path)) {
        if (!deleteRecursive($target_folder_path)) {
            echo "Failed to delete existing folder!";
            exit;
        }
    }

    // Create the new folder
    if (@mkdir($target_folder_path, 0777, true)) {
        echo "Folder created successfully!<br>";
        
        // Directory from which you want to copy files
        $source_dir = "/home3/smartag1/profitable.lk/firebase/7/7/"; // Change this to the source directory path
        
        // Copy all files and directories recursively
        if (copyRecursive($source_dir, $target_folder_path)) {
            echo "Files and folders copied successfully!<br>";
        } else {
            echo "Failed to copy files and folders!<br>";
        }
    } else {
        echo "Failed to create folder!";
    }
} else {
    echo "Folder name not provided!";
}

// Function to recursively delete files and folders
function deleteRecursive($dir_path) {
    if (!file_exists($dir_path)) {
        return true;
    }

    // Open the directory
    $dir = opendir($dir_path);
    
    // Loop through all files and folders in the directory
    while (false !== ($file = readdir($dir))) {
        if ($file != '.' && $file != '..') {
            $full_path = $dir_path . '/' . $file;

            if (is_dir($full_path)) {
                // Recursively delete subdirectories
                if (!deleteRecursive($full_path)) {
                    return false;
                }
            } else {
                // Delete files
                if (!unlink($full_path)) {
                    return false;
                }
            }
        }
    }

    // Close the directory and remove the parent directory
    closedir($dir);
    return rmdir($dir_path); // Remove the empty parent directory
}

// Function to recursively copy files and folders
function copyRecursive($src, $dst) {
    // Open source directory
    $dir = opendir($src);

    // Create destination directory if it does not exist
    if (!file_exists($dst)) {
        mkdir($dst, 0777, true);
    }

    // Loop through all files and folders in the source directory
    while (false !== ($file = readdir($dir))) {
        if ($file != '.' && $file != '..') {
            $src_path = $src . '/' . $file;
            $dst_path = $dst . '/' . $file;

            if (is_dir($src_path)) {
                // Recursively copy subdirectories
                if (!copyRecursive($src_path, $dst_path)) {
                    return false;
                }
            } else {
                // Copy files
                if (!copy($src_path, $dst_path)) {
                    return false;
                }
            }
        }
    }

    // Close source directory
    closedir($dir);
    return true;
}
?>
